<?php

// use App\Http\Controllers\ProfileController;
// use Illuminate\Foundation\Application;
// use Illuminate\Support\Facades\Route;
// use Inertia\Inertia;

// Route::get('/', function () {
//     return Inertia::render('Welcome', [
//         'canLogin' => Route::has('login'),
//         'canRegister' => Route::has('register'),
//         'laravelVersion' => Application::VERSION,
//         'phpVersion' => PHP_VERSION,
//     ]);
// });

// Route::get('/dashboard', function () {
//     return Inertia::render('Dashboard');
// })->middleware(['auth', 'verified'])->name('dashboard');

// Route::middleware('auth')->group(function () {
//     Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
//     Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
//     Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
// });

// require __DIR__.'/auth.php';



use Illuminate\Support\Facades\Route;
use Inertia\Inertia;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\Web\Landing\HomeController;
use App\Http\Controllers\Web\Landing\VisitController;
use App\Http\Controllers\Web\Landing\ExploreController;
use App\Http\Controllers\Web\Landing\ContactController;
use App\Http\Controllers\Web\Landing\AttractionDetailController;
use App\Http\Controllers\EventDetailController;
use App\Http\Controllers\CategoriesController;

/*
|--------------------------------------------------------------------------
| Public Landing Pages (SEO + SSR)
|--------------------------------------------------------------------------
|
| These routes represent the public-facing website for
| Greene County Visitor Center.
| No authentication or admin logic is allowed here.
|
*/

Route::get('/', HomeController::class)->name('home');
Route::get('/visit', VisitController::class)->name('visit');
Route::get('/explore', ExploreController::class)->name('explore');
Route::get('/attractions', function () {
    return Inertia::render('Landing/Attractions', [
        'meta' => [
            'title' => 'Attractions | Explore Greene County',
            'description' => 'Discover top-rated attractions in Greene County including museums, hiking trails, and historic sites.',
        ],
    ]);
})->name('attractions');
Route::get('/attractions/{slug}', AttractionDetailController::class)->name('attraction.show');
Route::get('/events', function () {
    return Inertia::render('Landing/Events', [
        'meta' => [
            'title' => 'Upcoming Events | Greene County',
            'description' => 'Browse upcoming festivals, concerts, and events happening in Greene County.',
        ],
    ]);
})->name('events');
Route::get('/events/{slug}', EventDetailController::class)->name('event.show');
Route::get('/cities', function () {
    return Inertia::render('Landing/Cities', [
        'meta' => [
            'title' => 'Cities & Communities | Greene County',
            'description' => 'Explore the charming cities and communities throughout Greene County, Virginia.',
        ],
    ]);
})->name('cities');
Route::get('/contact', ContactController::class)->name('contact');

/*
|--------------------------------------------------------------------------
| Category Pages (Hot & Trending Categories)
|--------------------------------------------------------------------------
|
| These routes are linked from the Home page category grid
| and provide detailed listing pages for each category
|
*/

Route::get('/categories/attractions', [CategoriesController::class, 'attractions'])->name('categories.attractions');
Route::get('/categories/dining', [CategoriesController::class, 'dining'])->name('categories.dining');
Route::get('/categories/events', [CategoriesController::class, 'events'])->name('categories.events');
Route::get('/categories/nature', [CategoriesController::class, 'nature'])->name('categories.nature');
Route::get('/categories/shopping', [CategoriesController::class, 'shopping'])->name('categories.shopping');
Route::get('/categories/heritage', [CategoriesController::class, 'heritage'])->name('categories.heritage');

/*
|--------------------------------------------------------------------------
| Admin / Dashboard (Hidden for now)
|--------------------------------------------------------------------------
|
| These routes are intentionally kept but NOT exposed
| in the Landing UI.
| They will be used later for the Admin Panel.
|
*/

Route::get('/dashboard', function () {
    return Inertia::render('Dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

/*
|--------------------------------------------------------------------------
| User Profile (Admin usage later)
|--------------------------------------------------------------------------
*/

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

/*
|--------------------------------------------------------------------------
| Authentication Routes
|--------------------------------------------------------------------------
*/

require __DIR__ . '/auth.php';
