<?php

return [
    'featured' => [
        [
            'id' => 1,
            'name' => 'Blue Ridge Mountain Festival',
            'slug' => 'blue-ridge-mountain-festival',
            'category' => 'Festival',
            'date' => '2025-06-15',
            'endDate' => '2025-06-17',
            'time' => '10:00 AM - 10:00 PM',
            'location' => 'Stanardsville Memorial Park',
            'city' => 'Stanardsville',
            'image' => 'https://images.unsplash.com/photo-1533900298318-6b8da08a523e?w=800&q=80',
            'description' => 'Annual three-day celebration of mountain music, crafts, food, and culture.',
            'long_description' => 'The Blue Ridge Mountain Festival is a beloved annual tradition attracting thousands of visitors from across the region. Enjoy live music from bluegrass, folk, and country performers on multiple stages. Browse artisan crafts and handmade goods from local makers. Taste authentic mountain cuisine and regional specialties. Kids activities include pony rides, face painting, and craft workshops. The festival showcases the best of Greene County culture and hospitality.',
            'tickets_url' => 'https://blueridgefestival.com/tickets',
            'price' => '$15-35 per day',
            'capacity' => 5000,
            'website' => 'https://blueridgefestival.com',
            'phone' => '(434) 985-2233',
            'email' => 'info@blueridgefestival.com',
            'rating' => 4.8,
            'reviews_count' => 642,
            'gallery' => [
                'https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=800&q=80',
                'https://images.unsplash.com/photo-1459749411175-04bf5292ceea?w=800&q=80',
                'https://images.unsplash.com/photo-1470225620780-dba8ba36b745?w=800&q=80',
                'https://images.unsplash.com/photo-1533900298318-6b8da08a523e?w=800&q=80',
            ],
            'features' => [
                'Live Music',
                'Food Vendors',
                'Arts & Crafts',
                'Family Activities',
                'Free Parking',
                'Local Performers',
            ],
        ],
        [
            'id' => 2,
            'name' => 'Wine & Food Pairing Dinner',
            'slug' => 'wine-food-pairing-dinner',
            'category' => 'Dining Event',
            'date' => '2025-07-20',
            'endDate' => '2025-07-20',
            'time' => '5:00 PM - 9:00 PM',
            'location' => 'Early Mountain Vineyards',
            'city' => 'Madison',
            'image' => 'https://images.unsplash.com/photo-1567521464027-f127ff144326?w=800&q=80',
            'description' => 'An elegant evening of fine wines paired with gourmet farm-to-table cuisine.',
            'long_description' => 'Experience a sophisticated evening at Early Mountain Vineyards featuring five courses of farm-fresh cuisine expertly paired with estate wines. Each dish has been specially designed to complement our award-winning wines. Enjoy views of the Blue Ridge Mountains while sipping premium selections. The chef will discuss each pairing and wine selection. Limited to 75 guests for an intimate experience.',
            'tickets_url' => 'https://earlymountain.com/events',
            'price' => '$85 per person',
            'capacity' => 75,
            'website' => 'https://earlymountain.com',
            'phone' => '(540) 948-9005',
            'email' => 'events@earlymountain.com',
            'rating' => 4.9,
            'reviews_count' => 189,
            'gallery' => [
                'https://images.unsplash.com/photo-1510812431401-41d2bd2722f3?w=800&q=80',
                'https://images.unsplash.com/photo-1572116469696-31de0f17cc34?w=800&q=80',
                'https://images.unsplash.com/photo-1598103442097-8b74394b95c6?w=800&q=80',
                'https://images.unsplash.com/photo-1567521464027-f127ff144326?w=800&q=80',
            ],
            'features' => [
                '5-Course Menu',
                'Wine Pairing',
                'Mountain Views',
                'Chef Presentation',
                'Fine Dining',
                'Sunset Experience',
            ],
        ],
        [
            'id' => 3,
            'name' => 'Summer Farmers Market',
            'slug' => 'summer-farmers-market',
            'category' => 'Market',
            'date' => '2025-06-01',
            'endDate' => '2025-09-30',
            'time' => '9:00 AM - 1:00 PM',
            'location' => 'Downtown Stanardsville',
            'city' => 'Stanardsville',
            'image' => 'https://images.unsplash.com/photo-1488841594351-ff119e4d52e9?w=800&q=80',
            'description' => 'Weekly farmers market with fresh local produce, dairy, and artisan goods.',
            'long_description' => 'Every Saturday morning through September, local farmers and producers gather to sell fresh seasonal produce, dairy products, honey, baked goods, and handmade crafts. Support local agriculture while enjoying the freshest ingredients. Meet the farmers, learn about sustainable practices, and enjoy live music from local musicians. The market creates a vibrant community gathering place.',
            'tickets_url' => '',
            'price' => 'Free to browse',
            'capacity' => 1000,
            'website' => 'https://greenecountyfarmersmarket.com',
            'phone' => '(434) 985-2100',
            'email' => 'info@farmersmarket.local',
            'rating' => 4.7,
            'reviews_count' => 445,
            'gallery' => [
                'https://images.unsplash.com/photo-1488459716781-41ccceffe0df?w=800&q=80',
                'https://images.unsplash.com/photo-1566242408471-80b0a0b92e44?w=800&q=80',
                'https://images.unsplash.com/photo-1488644531173-76f90e51f28d?w=800&q=80',
                'https://images.unsplash.com/photo-1488841594351-ff119e4d52e9?w=800&q=80',
            ],
            'features' => [
                'Fresh Produce',
                'Local Vendors',
                'Artisan Goods',
                'Live Music',
                'Family Friendly',
                'Rain or Shine',
            ],
        ],
        [
            'id' => 4,
            'name' => 'Moonlight Hiking Tour',
            'slug' => 'moonlight-hiking-tour',
            'category' => 'Outdoor Activity',
            'date' => '2025-07-10',
            'endDate' => '2025-07-10',
            'time' => '8:00 PM - 11:00 PM',
            'location' => 'Shenandoah National Park',
            'city' => 'Stanardsville',
            'image' => 'https://images.unsplash.com/photo-1506905925346-21bda4d32df4?w=800&q=80',
            'description' => 'Guided full-moon hiking experience through beautiful mountain trails.',
            'long_description' => 'Experience the magic of the mountains under the full moon. Our expert naturalist guides will lead you along a moderate 3-mile trail while sharing stories of the night sky and nocturnal wildlife. Perfect conditions for stargazing and wildlife observation. Bring a headlamp (we provide backups) and wear comfortable hiking shoes. Hot cocoa and snacks provided. Weather dependent.',
            'tickets_url' => 'https://shenandoahtours.com',
            'price' => '$45 per person',
            'capacity' => 30,
            'website' => 'https://shenandoahtours.com',
            'phone' => '(540) 999-4500',
            'email' => 'tours@shenandoah.local',
            'rating' => 4.9,
            'reviews_count' => 234,
            'gallery' => [
                'https://images.unsplash.com/photo-1464207687429-7505649dae38?w=800&q=80',
                'https://images.unsplash.com/photo-1519904981063-b0cf448d479e?w=800&q=80',
                'https://images.unsplash.com/photo-1426604342505-f3aaeeaaa0d3?w=800&q=80',
                'https://images.unsplash.com/photo-1506905925346-21bda4d32df4?w=800&q=80',
            ],
            'features' => [
                'Guided Tour',
                'Stargazing',
                'Wildlife Viewing',
                'Full Moon',
                'Moderate Difficulty',
                'Snacks Included',
            ],
        ],
    ],
];
