<?php

/**
 * Static data for site content
 * Categories, testimonials, and other general content
 */

return [
    'categories' => [
        [
            'id' => 'attractions',
            'name' => 'Attractions',
            'icon' => 'map-pin',
            'color' => 'blue',
            'count' => '24',
            'route' => '/categories/attractions',
        ],
        [
            'id' => 'dining',
            'name' => 'Dining',
            'icon' => 'utensils',
            'color' => 'red',
            'count' => '18',
            'route' => '/categories/dining',
        ],
        [
            'id' => 'events',
            'name' => 'Events',
            'icon' => 'calendar',
            'color' => 'purple',
            'count' => '12',
            'route' => '/categories/events',
        ],
        [
            'id' => 'nature',
            'name' => 'Nature & Trails',
            'icon' => 'leaf',
            'color' => 'green',
            'count' => '15',
            'route' => '/categories/nature',
        ],
        [
            'id' => 'shopping',
            'name' => 'Shopping',
            'icon' => 'shopping-bag',
            'color' => 'pink',
            'count' => '22',
            'route' => '/categories/shopping',
        ],
        [
            'id' => 'culture',
            'name' => 'Culture & Heritage',
            'icon' => 'landmark',
            'color' => 'orange',
            'count' => '10',
            'route' => '/categories/heritage',
        ],
    ],

    'testimonials' => [
        [
            'id' => 1,
            'name' => 'Sarah Johnson',
            'role' => 'Visitor from New York',
            'image' => 'https://images.unsplash.com/photo-1494790108377-be9c29b29330?w=100&h=100&fit=crop',
            'content' => 'Greene County exceeded all my expectations! The scenic beauty, warm hospitality, and incredible dining experiences made this the perfect getaway.',
            'rating' => 5,
        ],
        [
            'id' => 2,
            'name' => 'Michael Chen',
            'role' => 'Nature Enthusiast',
            'image' => 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=100&h=100&fit=crop',
            'content' => 'The hiking trails here are phenomenal! Every turn offers breathtaking views. I\'ve recommended this place to all my friends.',
            'rating' => 5,
        ],
        [
            'id' => 3,
            'name' => 'Emma Rodriguez',
            'role' => 'Food Blogger',
            'image' => 'https://images.unsplash.com/photo-1438761681033-6461ffad8d80?w=100&h=100&fit=crop',
            'content' => 'The farm-to-table dining experience is unmatched. Supporting local restaurants has never been this delicious!',
            'rating' => 5,
        ],
        [
            'id' => 4,
            'name' => 'James Wilson',
            'role' => 'Family Travel Expert',
            'image' => 'https://images.unsplash.com/photo-1500648767791-00dcc994a43e?w=100&h=100&fit=crop',
            'content' => 'Perfect destination for families! Our kids loved the outdoor activities, and we appreciated the relaxed pace.',
            'rating' => 5,
        ],
    ],

    'news' => [
        [
            'id' => 1,
            'title' => 'New Hiking Trail Opens in Blue Ridge',
            'date' => '2025-12-28',
            'image' => 'https://images.unsplash.com/photo-1506905925346-21bda4d32df4?w=600&h=400&fit=crop',
            'excerpt' => 'A brand new scenic hiking trail has officially opened, offering panoramic views of the Blue Ridge Mountains.',
            'category' => 'News',
        ],
        [
            'id' => 2,
            'title' => 'Downtown Development Brings Modern Amenities',
            'date' => '2025-12-20',
            'image' => 'https://images.unsplash.com/photo-1488646953014-85cb44e25828?w=600&h=400&fit=crop',
            'excerpt' => 'New shops, galleries, and restaurants are transforming the historic downtown district while preserving its charm.',
            'category' => 'News',
        ],
        [
            'id' => 3,
            'title' => 'Spring Wine Festival Dates Announced',
            'date' => '2025-12-15',
            'image' => 'https://images.unsplash.com/photo-1510812431401-41d2cab2707d?w=600&h=400&fit=crop',
            'excerpt' => 'Mark your calendars for the annual Spring Wine Festival celebrating local vineyards and gourmet cuisine.',
            'category' => 'Events',
        ],
    ],
];
