<?php

/**
 * Static data for Greene County attractions
 * Enhanced with detailed information for demo purposes
 */

return [
    'categories' => [
        'attractions',
        'dining',
        'nature',
        'shopping',
        'culture',
        'events',
    ],

    'featured' => [
        [
            'id' => 1,
            'name' => 'Shenandoah National Park',
            'slug' => 'shenandoah-national-park',
            'title' => 'Shenandoah National Park',
            'category' => 'nature',
            'city' => 'Stanardsville',
            'address' => '3655 US Highway 33 East',
            'phone' => '(540) 999-3500',
            'email' => 'shen_information@nps.gov',
            'website' => 'https://www.nps.gov/shen',
            'hours' => 'Open 24 hours, year-round',
            'image' => 'https://images.unsplash.com/photo-1506905925346-21bda4d32df4?w=1200&q=80',
            'description' => 'Explore over 200,000 acres of protected lands with stunning mountain views and diverse wildlife.',
            'long_description' => 'Shenandoah National Park encompasses 200,000 acres of protected lands that are havens for deer, songbirds, and black bears. Cascading waterfalls, spectacular vistas, and over 500 miles of trails provide endless opportunities for exploration. Skyline Drive, a 105-mile scenic byway, runs through the heart of the park. Visit in spring for wildflowers, summer for hiking, fall for spectacular foliage, or winter for peaceful solitude.',
            'rating' => 4.9,
            'reviews_count' => 3542,
            'featured' => true,
            'gallery' => [
                'https://images.unsplash.com/photo-1445262102387-5fbb30a5e59d?w=800&q=80',
                'https://images.unsplash.com/photo-1501594907352-04cda38ebc29?w=800&q=80',
                'https://images.unsplash.com/photo-1469854523086-cc02fe5d8800?w=800&q=80',
            ],
            'features' => [
                'Hiking Trails',
                'Wildlife Viewing',
                'Camping',
                'Scenic Drive',
                'Waterfalls',
                'Visitor Center',
            ],
        ],
        [
            'id' => 2,
            'name' => 'Graves\' Mountain Lodge',
            'slug' => 'graves-mountain-lodge',
            'title' => 'Graves\' Mountain Lodge',
            'category' => 'attractions',
            'city' => 'Syria',
            'address' => '3350 Graves Mill Road',
            'phone' => '(540) 923-4231',
            'email' => 'info@gravesmountain.com',
            'website' => 'https://www.gravesmountain.com',
            'hours' => 'Open daily, seasonal hours vary',
            'image' => 'https://images.unsplash.com/photo-1469854523086-cc02fe5d8800?w=1200&q=80',
            'description' => 'Historic mountain lodge offering lodging, dining, and year-round outdoor activities.',
            'long_description' => 'Graves\' Mountain Lodge has been welcoming guests since 1857. Set on 9,000 acres at the foot of the Blue Ridge Mountains, the lodge offers rustic accommodations, farm-to-table dining, and activities for all seasons. Enjoy horseback riding, hiking, fishing, and swimming in summer. In fall, explore apple orchards and pumpkin patches. Winter brings sleigh rides and cozy fireside gatherings. Spring features wildflower hikes and lamb feeding.',
            'rating' => 4.7,
            'reviews_count' => 856,
            'featured' => true,
            'gallery' => [
                'https://images.unsplash.com/photo-1582719508461-905c673771fd?w=800&q=80',
                'https://images.unsplash.com/photo-1566073771259-6a8506099945?w=800&q=80',
                'https://images.unsplash.com/photo-1542314831-068cd1dbfeeb?w=800&q=80',
            ],
            'features' => [
                'Lodging',
                'Restaurant',
                'Horseback Riding',
                'Fishing',
                'Apple Orchard',
                'Gift Shop',
            ],
        ],
        [
            'id' => 3,
            'name' => 'Early Mountain Vineyards',
            'slug' => 'early-mountain-vineyards',
            'title' => 'Early Mountain Vineyards',
            'category' => 'dining',
            'city' => 'Madison',
            'address' => '6109 Wolftown-Hood Road',
            'phone' => '(540) 948-9005',
            'email' => 'info@earlymountain.com',
            'website' => 'https://www.earlymountain.com',
            'hours' => 'Wed-Sun: 11 AM - 5 PM',
            'image' => 'https://images.unsplash.com/photo-1506905925346-21bda4d32df4?w=1200&q=80',
            'description' => 'Award-winning winery with stunning mountain views and farm-to-table cuisine.',
            'long_description' => 'Early Mountain Vineyards combines world-class wines with breathtaking Blue Ridge Mountain views. The 500-acre estate produces acclaimed Chardonnay, Riesling, and Eluvium blends. The tasting room and restaurant feature locally-sourced cuisine paired perfectly with estate wines. Enjoy picnics on the lawn, vineyard tours, or special events throughout the year. The property also includes hiking trails and stunning photo opportunities.',
            'rating' => 4.8,
            'reviews_count' => 642,
            'featured' => true,
            'gallery' => [
                'https://images.unsplash.com/photo-1586534382092-623ef82cc885?w=800&q=80',
                'https://images.unsplash.com/photo-1572116469696-31de0f17cc34?w=800&q=80',
                'https://images.unsplash.com/photo-1510812431401-41d2bd2722f3?w=800&q=80',
            ],
            'features' => [
                'Wine Tasting',
                'Restaurant',
                'Outdoor Seating',
                'Private Events',
                'Vineyard Tours',
                'Gift Shop',
            ],
        ],
        [
            'id' => 4,
            'name' => 'Rapidan River Kayaking',
            'slug' => 'rapidan-river-kayaking',
            'title' => 'Rapidan River Kayaking',
            'category' => 'nature',
            'city' => 'Ruckersville',
            'address' => '13278 Oakpark Road',
            'phone' => '(434) 985-4315',
            'email' => 'paddle@rapidanriver.com',
            'website' => 'https://www.rapidanriverkayaking.com',
            'hours' => 'May-October: 9 AM - 6 PM',
            'image' => 'https://images.unsplash.com/photo-1545042746-6f9ea24a45cb?w=1200&q=80',
            'description' => 'Guided kayaking adventures on the scenic Rapidan River with all equipment provided.',
            'long_description' => 'Experience the beauty of the Rapidan River with our guided kayaking tours. Perfect for beginners and experienced paddlers alike, our trips range from 2-6 hours and showcase the river\'s natural beauty, wildlife, and gentle rapids. All equipment is provided including kayaks, paddles, life vests, and dry bags. Our experienced guides ensure a safe and memorable adventure while sharing local history and ecology.',
            'rating' => 4.9,
            'reviews_count' => 428,
            'featured' => true,
            'gallery' => [
                'https://images.unsplash.com/photo-1523805009345-7448845a9e53?w=800&q=80',
                'https://images.unsplash.com/photo-1502481851512-e9e2529bfbf9?w=800&q=80',
                'https://images.unsplash.com/photo-1484600899469-230e8d1d59c0?w=800&q=80',
                'https://images.unsplash.com/photo-1506905925346-21bda4d32df4?w=800&q=80',
            ],
            'features' => [
                'Guided Tours',
                'Equipment Rental',
                'Beginner Friendly',
                'Wildlife Viewing',
                'Photography',
                'Group Discounts',
            ],
        ],
    ],

    'popular' => [
        [
            'id' => 5,
            'name' => 'Greene County Historical Society',
            'slug' => 'greene-county-historical-society',
            'title' => 'Greene County Historical Society',
            'category' => 'culture',
            'city' => 'Stanardsville',
            'address' => '108 Main Street',
            'phone' => '(434) 985-5210',
            'email' => 'info@gchistory.org',
            'website' => 'https://www.gchistory.org',
            'hours' => 'Tue-Sat: 10 AM - 4 PM',
            'image' => 'https://images.unsplash.com/photo-1564399579883-451a5d44ec6a?w=1200&q=80',
            'description' => 'Discover Greene County\'s rich history through exhibits, archives, and guided tours.',
            'long_description' => 'The Greene County Historical Society preserves and shares the rich history of our community through rotating exhibits, extensive archives, and educational programs. Explore artifacts from Native American settlements, colonial era, Civil War, and 20th century development. The museum features interactive displays, genealogy research center, and gift shop with local history books.',
            'rating' => 4.6,
            'reviews_count' => 234,
            'featured' => false,
            'gallery' => [
                'https://images.unsplash.com/photo-1513735539099-65b4b4b9e674?w=800&q=80',
                'https://images.unsplash.com/photo-1534113414509-0a3a49849874?w=800&q=80',
            ],
            'features' => [
                'Museum Exhibits',
                'Archives',
                'Guided Tours',
                'Gift Shop',
                'Research Library',
                'Educational Programs',
            ],
        ],
        [
            'id' => 6,
            'name' => 'Mountain View Orchards',
            'slug' => 'mountain-view-orchards',
            'title' => 'Mountain View Orchards',
            'category' => 'attractions',
            'city' => 'Dyke',
            'address' => '4295 Dyke Road',
            'phone' => '(434) 939-4890',
            'email' => 'pick@mountainvieworchards.com',
            'website' => 'https://www.mountainvieworchards.com',
            'hours' => 'Aug-Nov: Daily 9 AM - 6 PM',
            'image' => 'https://images.unsplash.com/photo-1537804959801-e2b6462a525e?w=1200&q=80',
            'description' => 'Family-friendly apple orchard offering pick-your-own fruit and homemade cider.',
            'long_description' => 'Mountain View Orchards is a family-owned farm featuring over 20 varieties of apples, peaches, and seasonal produce. Enjoy pick-your-own fruit during harvest season, fresh-pressed apple cider, and homemade baked goods. The farm store sells local honey, jams, and crafts. Kids love the petting zoo, corn maze, and hayrides. Perfect for family outings and autumn celebrations.',
            'rating' => 4.7,
            'reviews_count' => 589,
            'featured' => false,
            'gallery' => [
                'https://images.unsplash.com/photo-1567306226416-28f0efdc88ce?w=800&q=80',
                'https://images.unsplash.com/photo-1560713796-7a5a82f5ae5f?w=800&q=80',
            ],
            'features' => [
                'Pick Your Own',
                'Farm Store',
                'Cider Mill',
                'Petting Zoo',
                'Corn Maze',
                'Picnic Area',
            ],
        ],
        [
            'id' => 7,
            'name' => 'The Palette Artisan Gallery',
            'slug' => 'palette-artisan-gallery',
            'title' => 'The Palette Artisan Gallery',
            'category' => 'shopping',
            'city' => 'Stanardsville',
            'address' => '124 Main Street',
            'phone' => '(434) 985-6789',
            'email' => 'art@palettegreene.com',
            'website' => 'https://www.palettegreene.com',
            'hours' => 'Wed-Sun: 11 AM - 5 PM',
            'image' => 'https://images.unsplash.com/photo-1567521464027-f127ff144326?w=1200&q=80',
            'description' => 'Contemporary art gallery showcasing local and regional artists.',
            'long_description' => 'The Palette Artisan Gallery celebrates the vibrant arts community of Greene County and beyond. Features rotating exhibitions of paintings, sculpture, pottery, jewelry, and textiles from talented local and regional artists. The gallery also hosts workshops, artist talks, and special events. Find unique gifts and one-of-a-kind pieces while supporting local artists.',
            'rating' => 4.5,
            'reviews_count' => 178,
            'featured' => false,
            'gallery' => [
                'https://images.unsplash.com/photo-1577083552431-6e5fd01e6ce0?w=800&q=80',
                'https://images.unsplash.com/photo-1547826039-bfc35e0f1ea8?w=800&q=80',
            ],
            'features' => [
                'Art Exhibitions',
                'Local Artists',
                'Workshops',
                'Custom Framing',
                'Gift Shop',
                'Art Classes',
            ],
        ],
        [
            'id' => 8,
            'name' => 'Blue Ridge Cafe',
            'slug' => 'blue-ridge-cafe',
            'title' => 'Blue Ridge Cafe',
            'category' => 'dining',
            'city' => 'Ruckersville',
            'address' => '45 Commons Drive',
            'phone' => '(434) 990-2233',
            'email' => 'hello@blueridgecafe.com',
            'website' => 'https://www.blueridgecafe.com',
            'hours' => 'Mon-Sat: 7 AM - 9 PM, Sun: 8 AM - 3 PM',
            'image' => 'https://images.unsplash.com/photo-1517248135467-4c7edcad34c4?w=1200&q=80',
            'description' => 'Farm-to-table restaurant featuring locally-sourced ingredients and Southern comfort food.',
            'long_description' => 'Blue Ridge Cafe is Greene County\'s favorite gathering spot for delicious, honest food. We partner with local farms to bring you the freshest seasonal ingredients prepared with care. Our menu features Southern classics with a modern twist - from buttermilk fried chicken to seasonal vegetable plates. Don\'t miss our famous biscuits and homemade pies. Cozy atmosphere perfect for families and friends.',
            'rating' => 4.8,
            'reviews_count' => 742,
            'featured' => false,
            'gallery' => [
                'https://images.unsplash.com/photo-1555396273-367ea4eb4db5?w=800&q=80',
                'https://images.unsplash.com/photo-1546069901-ba9599a7e63c?w=800&q=80',
            ],
            'features' => [
                'Farm-to-Table',
                'Outdoor Seating',
                'Kids Menu',
                'Takeout Available',
                'Catering',
                'Local Beer & Wine',
            ],
        ],
    ],
];
