import { defineComponent, inject, computed, ref, mergeProps, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderAttr, ssrInterpolate, ssrRenderClass, ssrRenderList } from "vue/server-renderer";
import { _ as _export_sfc } from "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "GallerySlider",
  __ssrInlineRender: true,
  props: {
    images: {},
    title: { default: "Gallery" },
    altPrefix: { default: "Gallery Image" }
  },
  setup(__props) {
    const isDarkMode = inject("isDarkMode", computed(() => false));
    const props = __props;
    const currentImageIndex = ref(0);
    const currentImage = computed(() => props.images[currentImageIndex.value]);
    const imageCount = computed(() => props.images.length);
    const imageNumber = computed(() => currentImageIndex.value + 1);
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: ["rounded-2xl shadow-lg overflow-hidden transition-colors duration-300", unref(isDarkMode) ? "bg-gray-800" : "bg-white"]
      }, _attrs))} data-v-196b75f0><div class="relative bg-gray-900 h-[400px] md:h-[500px] group overflow-hidden" data-v-196b75f0><!--[--><img${ssrRenderAttr("src", currentImage.value)}${ssrRenderAttr("alt", `${__props.altPrefix} ${imageNumber.value}`)} class="absolute inset-0 w-full h-full object-cover transition-opacity duration-500" data-v-196b75f0><!--]--><div class="absolute inset-0 bg-gradient-to-t from-black/50 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300" data-v-196b75f0></div>`);
      if (imageCount.value > 1) {
        _push(`<button class="absolute left-4 top-1/2 -translate-y-1/2 z-10 bg-white/20 hover:bg-white/40 backdrop-blur-sm text-white p-3 rounded-full transition-all duration-300 opacity-0 group-hover:opacity-100" aria-label="Previous Image" data-v-196b75f0><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-196b75f0><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" data-v-196b75f0></path></svg></button>`);
      } else {
        _push(`<!---->`);
      }
      if (imageCount.value > 1) {
        _push(`<button class="absolute right-4 top-1/2 -translate-y-1/2 z-10 bg-white/20 hover:bg-white/40 backdrop-blur-sm text-white p-3 rounded-full transition-all duration-300 opacity-0 group-hover:opacity-100" aria-label="Next Image" data-v-196b75f0><svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" data-v-196b75f0><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" data-v-196b75f0></path></svg></button>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="absolute bottom-4 right-4 z-10 bg-black/70 backdrop-blur-sm text-white px-4 py-2 rounded-lg text-sm font-semibold" data-v-196b75f0>${ssrInterpolate(imageNumber.value)} / ${ssrInterpolate(imageCount.value)}</div></div>`);
      if (imageCount.value > 1) {
        _push(`<div class="${ssrRenderClass([unref(isDarkMode) ? "bg-gray-900" : "bg-gray-50", "p-4 transition-colors duration-300"])}" data-v-196b75f0><div class="flex gap-2 overflow-x-auto pb-2" data-v-196b75f0><!--[-->`);
        ssrRenderList(__props.images, (img, index) => {
          _push(`<button class="${ssrRenderClass([
            index === currentImageIndex.value ? "border-red-600 ring-2 ring-red-600 scale-105" : "border-transparent hover:border-gray-400",
            "flex-shrink-0 w-20 h-20 rounded-lg overflow-hidden border-2 transition-all duration-300 hover:scale-105"
          ])}"${ssrRenderAttr("aria-label", `View image ${index + 1}`)} data-v-196b75f0><img${ssrRenderAttr("src", img)}${ssrRenderAttr("alt", `${__props.altPrefix} ${index + 1}`)} class="w-full h-full object-cover" data-v-196b75f0></button>`);
        });
        _push(`<!--]--></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="${ssrRenderClass([unref(isDarkMode) ? "border-gray-700" : "border-gray-200", "p-6 border-t transition-colors duration-300"])}" data-v-196b75f0><h2 class="${ssrRenderClass([unref(isDarkMode) ? "text-white" : "text-gray-900", "text-2xl font-bold transition-colors duration-300"])}" data-v-196b75f0>${ssrInterpolate(__props.title)}</h2><p class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-400" : "text-gray-600", "text-sm transition-colors duration-300 mt-1"])}" data-v-196b75f0><span class="font-semibold" data-v-196b75f0>${ssrInterpolate(imageCount.value)}</span> ${ssrInterpolate(imageCount.value === 1 ? "photo" : "photos")} available </p></div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/GallerySlider.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const GallerySlider = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-196b75f0"]]);
export {
  GallerySlider as G
};
