import { defineComponent, inject, computed, ref, mergeProps, unref, withCtx, createBlock, createTextVNode, openBlock, createVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderStyle, ssrRenderComponent, ssrRenderClass, ssrRenderAttr, ssrIncludeBooleanAttr, ssrLooseContain, ssrLooseEqual, ssrRenderList, ssrInterpolate } from "vue/server-renderer";
import { Link } from "@inertiajs/vue3";
import { G as GallerySlider } from "./GallerySlider-BDj3OZAy.js";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const itemsPerPage = 6;
const _sfc_main = /* @__PURE__ */ defineComponent({
  __name: "EventsCategory",
  __ssrInlineRender: true,
  props: {
    events: {}
  },
  setup(__props) {
    const isDarkMode = inject("isDarkMode", computed(() => false));
    const sortBy = ref("upcoming");
    const filterMonth = ref("");
    const viewMode = ref("grid");
    const searchQuery = ref("");
    const currentPage = ref(1);
    const galleryImages = [
      "https://images.unsplash.com/photo-1516399520891-468df5d13cb8?w=1200&h=600&fit=crop",
      "https://images.unsplash.com/photo-1549737328-8b93e4d8888f?w=1200&h=600&fit=crop",
      "https://images.unsplash.com/photo-1511632765486-a01980e01a18?w=1200&h=600&fit=crop",
      "https://images.unsplash.com/photo-1492684223066-81342ee5ff30?w=1200&h=600&fit=crop"
    ];
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: ["min-h-screen", unref(isDarkMode) ? "bg-gray-900" : "bg-gray-50"]
      }, _attrs))}><div class="relative bg-gradient-to-r from-blue-500 to-blue-700 text-white overflow-hidden" style="${ssrRenderStyle({ "min-height": "400px" })}"><div class="absolute inset-0">`);
      _push(ssrRenderComponent(GallerySlider, {
        images: galleryImages,
        "show-thumbnails": false
      }, null, _parent));
      _push(`</div><div class="absolute inset-0 bg-gradient-to-r from-blue-600/40 to-blue-700/40"></div><div class="relative max-w-7xl mx-auto px-4 py-16">`);
      _push(ssrRenderComponent(unref(Link), {
        href: "/",
        class: "inline-flex items-center gap-2 mb-6 hover:opacity-80 transition"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"${_scopeId}><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"${_scopeId}></path></svg> Back `);
          } else {
            return [
              (openBlock(), createBlock("svg", {
                class: "w-5 h-5",
                fill: "none",
                stroke: "currentColor",
                viewBox: "0 0 24 24"
              }, [
                createVNode("path", {
                  "stroke-linecap": "round",
                  "stroke-linejoin": "round",
                  "stroke-width": "2",
                  d: "M15 19l-7-7 7-7"
                })
              ])),
              createTextVNode(" Back ")
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<h1 class="text-5xl font-bold mb-3">📅 Events</h1><p class="text-2xl text-blue-100">Find 12 exciting events happening this season</p></div></div><div class="bg-white dark:bg-gray-800 border-b dark:border-gray-700 sticky top-0 z-10 shadow-sm"><div class="max-w-7xl mx-auto px-4 py-6"><div class="flex gap-4 flex-wrap items-end justify-between"><div class="flex gap-4 flex-wrap items-end flex-1"><div class="flex-1 min-w-[250px]"><label class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-300" : "text-gray-700", "block text-sm font-medium mb-2"])}">Search</label><input${ssrRenderAttr("value", searchQuery.value)} type="text" placeholder="Search events..." class="${ssrRenderClass([unref(isDarkMode) ? "bg-gray-700 border-gray-600 text-white placeholder-gray-400" : "bg-white border-gray-300", "w-full px-4 py-2 border rounded-lg"])}"></div><div><label class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-300" : "text-gray-700", "block text-sm font-medium mb-2"])}">Sort By</label><select class="${ssrRenderClass([unref(isDarkMode) ? "bg-gray-700 border-gray-600 text-white" : "bg-white border-gray-300", "px-4 py-2 border rounded-lg"])}"><option value="upcoming"${ssrIncludeBooleanAttr(Array.isArray(sortBy.value) ? ssrLooseContain(sortBy.value, "upcoming") : ssrLooseEqual(sortBy.value, "upcoming")) ? " selected" : ""}>Upcoming</option><option value="popular"${ssrIncludeBooleanAttr(Array.isArray(sortBy.value) ? ssrLooseContain(sortBy.value, "popular") : ssrLooseEqual(sortBy.value, "popular")) ? " selected" : ""}>Most Popular</option><option value="featured"${ssrIncludeBooleanAttr(Array.isArray(sortBy.value) ? ssrLooseContain(sortBy.value, "featured") : ssrLooseEqual(sortBy.value, "featured")) ? " selected" : ""}>Featured</option></select></div><div><label class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-300" : "text-gray-700", "block text-sm font-medium mb-2"])}">Filter by Month</label><select class="${ssrRenderClass([unref(isDarkMode) ? "bg-gray-700 border-gray-600 text-white" : "bg-white border-gray-300", "px-4 py-2 border rounded-lg"])}"><option value=""${ssrIncludeBooleanAttr(Array.isArray(filterMonth.value) ? ssrLooseContain(filterMonth.value, "") : ssrLooseEqual(filterMonth.value, "")) ? " selected" : ""}>All Months</option><option value="jan"${ssrIncludeBooleanAttr(Array.isArray(filterMonth.value) ? ssrLooseContain(filterMonth.value, "jan") : ssrLooseEqual(filterMonth.value, "jan")) ? " selected" : ""}>January</option><option value="jun"${ssrIncludeBooleanAttr(Array.isArray(filterMonth.value) ? ssrLooseContain(filterMonth.value, "jun") : ssrLooseEqual(filterMonth.value, "jun")) ? " selected" : ""}>June</option><option value="jul"${ssrIncludeBooleanAttr(Array.isArray(filterMonth.value) ? ssrLooseContain(filterMonth.value, "jul") : ssrLooseEqual(filterMonth.value, "jul")) ? " selected" : ""}>July</option><option value="sep"${ssrIncludeBooleanAttr(Array.isArray(filterMonth.value) ? ssrLooseContain(filterMonth.value, "sep") : ssrLooseEqual(filterMonth.value, "sep")) ? " selected" : ""}>September</option></select></div></div><div><label class="${ssrRenderClass([unref(isDarkMode) ? "text-gray-300" : "text-gray-700", "block text-sm font-medium mb-2"])}">View</label><div class="${ssrRenderClass([unref(isDarkMode) ? "border-gray-600 bg-gray-700" : "border-gray-300 bg-gray-100", "flex gap-1 border rounded-lg p-1"])}"><button class="${ssrRenderClass([viewMode.value === "grid" ? "bg-blue-500 text-white" : unref(isDarkMode) ? "text-gray-300 hover:bg-gray-600" : "text-gray-700 hover:bg-gray-200", "px-3 py-2 rounded transition"])}"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path></svg></button><button class="${ssrRenderClass([viewMode.value === "list" ? "bg-blue-500 text-white" : unref(isDarkMode) ? "text-gray-300 hover:bg-gray-600" : "text-gray-700 hover:bg-gray-200", "px-3 py-2 rounded transition"])}"><svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path></svg></button></div></div></div></div></div><div class="max-w-7xl mx-auto px-4 py-12">`);
      if (viewMode.value === "grid") {
        _push(`<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6"><!--[-->`);
        ssrRenderList(__props.events, (event) => {
          _push(ssrRenderComponent(unref(Link), {
            key: event.id,
            href: `/events/${event.id}`,
            class: "relative rounded-lg overflow-hidden shadow-lg hover:shadow-2xl transition-all duration-300 group cursor-pointer",
            style: { "height": "350px" }
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<img${ssrRenderAttr("src", event.image)}${ssrRenderAttr("alt", event.name)} class="absolute inset-0 w-full h-full object-cover group-hover:scale-105 transition-transform duration-500"${_scopeId}><div class="absolute inset-0 bg-gradient-to-t from-black/80 via-black/40 to-transparent"${_scopeId}></div><div class="relative h-full flex flex-col justify-end p-6"${_scopeId}><div class="flex items-center gap-2 text-sm mb-2 text-white/90"${_scopeId}><span${_scopeId}>📅</span> ${ssrInterpolate(event.date)}</div><h3 class="text-2xl font-bold text-white mb-3 line-clamp-2"${_scopeId}>${ssrInterpolate(event.name)}</h3><div class="flex items-center gap-3"${_scopeId}><div class="flex items-center gap-1"${_scopeId}><span class="text-yellow-400 text-lg"${_scopeId}>⭐</span><span class="text-white font-semibold"${_scopeId}>${ssrInterpolate(event.rating)}</span><span class="text-white/70 text-sm"${_scopeId}>(${ssrInterpolate(Math.floor(Math.random() * 500 + 200))} reviews)</span></div><span class="px-3 py-1 bg-blue-500 text-white text-xs font-semibold rounded-full"${_scopeId}>events</span></div></div>`);
              } else {
                return [
                  createVNode("img", {
                    src: event.image,
                    alt: event.name,
                    class: "absolute inset-0 w-full h-full object-cover group-hover:scale-105 transition-transform duration-500"
                  }, null, 8, ["src", "alt"]),
                  createVNode("div", { class: "absolute inset-0 bg-gradient-to-t from-black/80 via-black/40 to-transparent" }),
                  createVNode("div", { class: "relative h-full flex flex-col justify-end p-6" }, [
                    createVNode("div", { class: "flex items-center gap-2 text-sm mb-2 text-white/90" }, [
                      createVNode("span", null, "📅"),
                      createTextVNode(" " + toDisplayString(event.date), 1)
                    ]),
                    createVNode("h3", { class: "text-2xl font-bold text-white mb-3 line-clamp-2" }, toDisplayString(event.name), 1),
                    createVNode("div", { class: "flex items-center gap-3" }, [
                      createVNode("div", { class: "flex items-center gap-1" }, [
                        createVNode("span", { class: "text-yellow-400 text-lg" }, "⭐"),
                        createVNode("span", { class: "text-white font-semibold" }, toDisplayString(event.rating), 1),
                        createVNode("span", { class: "text-white/70 text-sm" }, "(" + toDisplayString(Math.floor(Math.random() * 500 + 200)) + " reviews)", 1)
                      ]),
                      createVNode("span", { class: "px-3 py-1 bg-blue-500 text-white text-xs font-semibold rounded-full" }, "events")
                    ])
                  ])
                ];
              }
            }),
            _: 2
          }, _parent));
        });
        _push(`<!--]--></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="flex justify-center items-center gap-2 mt-12"><button${ssrIncludeBooleanAttr(currentPage.value === 1) ? " disabled" : ""} class="${ssrRenderClass([[
        currentPage.value === 1 ? "opacity-50 cursor-not-allowed" : "hover:bg-blue-500 hover:text-white",
        unref(isDarkMode) ? "bg-gray-700 text-white" : "bg-gray-200 text-gray-700"
      ], "px-4 py-2 rounded-lg transition"])}"> Previous </button><!--[-->`);
      ssrRenderList(Math.ceil(__props.events.length / itemsPerPage), (page) => {
        _push(`<button class="${ssrRenderClass([currentPage.value === page ? "bg-blue-500 text-white" : unref(isDarkMode) ? "bg-gray-700 text-white hover:bg-gray-600" : "bg-gray-200 text-gray-700 hover:bg-gray-300", "px-4 py-2 rounded-lg transition"])}">${ssrInterpolate(page)}</button>`);
      });
      _push(`<!--]--><button${ssrIncludeBooleanAttr(currentPage.value === Math.ceil(__props.events.length / itemsPerPage)) ? " disabled" : ""} class="${ssrRenderClass([[
        currentPage.value === Math.ceil(__props.events.length / itemsPerPage) ? "opacity-50 cursor-not-allowed" : "hover:bg-blue-500 hover:text-white",
        unref(isDarkMode) ? "bg-gray-700 text-white" : "bg-gray-200 text-gray-700"
      ], "px-4 py-2 rounded-lg transition"])}"> Next </button></div></div></div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Categories/EventsCategory.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
