<?php

namespace App\Http\Controllers\Web\Landing;

use Inertia\Inertia;

class AttractionDetailController
{
    public function __invoke(string $slug)
    {
        // Get all attractions
        $allAttractions = array_merge(
            config('attractions.featured'),
            config('attractions.popular')
        );

        // Find the attraction by slug
        $attraction = collect($allAttractions)->firstWhere('slug', $slug);

        if (!$attraction) {
            abort(404);
        }

        // Get nearby attractions (exclude current one)
        $nearbyAttractions = collect($allAttractions)
            ->where('city', $attraction['city'])
            ->where('slug', '!=', $slug)
            ->take(3)
            ->values()
            ->toArray();

        return Inertia::render('Landing/AttractionDetail', [
            'meta' => [
                'title' => $attraction['name'] . ' | Explore Greene County',
                'description' => $attraction['long_description'] ?? $attraction['description'],
            ],
            'attraction' => array_merge($attraction, [
                'nearby_attractions' => $nearbyAttractions,
            ]),
        ]);
    }
}
