# Voice Interaction Toggle Feature

## Overview
Users can now toggle voice interaction on/off in the Greene Guide chatbot, allowing them to switch between voice-based and text-only communication modes.

## Features Implemented

### 1. **Voice Toggle Button**
- Located in the chat header next to the close button
- Shows a speaker icon when voice is enabled 🔊
- Shows a muted speaker icon when voice is disabled 🔇
- Hover tooltip shows: "Disable voice" or "Enable voice"

### 2. **State Management**
- Added `voiceEnabled` reactive state (initialized as `true`)
- Toggles between voice and text modes
- Persists the mode during the chat session

### 3. **Voice Control Logic**
- When voice is **enabled**: 
  - Voice button (🎤 Speak) is displayed
  - Bot responses are automatically spoken out loud
  - Welcome message is spoken
  
- When voice is **disabled**:
  - Voice button is hidden
  - "💬 Text only mode" message is displayed instead
  - Bot responses are only shown as text
  - No automatic voice output

### 4. **User Experience Features**
- **Seamless switching**: Users can toggle voice on/off anytime during conversation
- **Smart cleanup**: Clicking voice toggle cancels any ongoing speech
- **Responsive**: Works on both light and dark modes
- **Non-intrusive**: Text input remains fully functional in both modes

## Code Changes

### Modified Files
- `resources/js/Components/ChatBot.vue`

### Key Functions
1. **`toggleVoice()`** - Main toggle function
   - Switches `voiceEnabled` state
   - Cancels ongoing speech
   - Stops listening if active

2. **`sendMessage()`** - Updated to check voice state
   - Only calls `speakMessage()` if `voiceEnabled` is true

3. **Template changes**:
   - Header now includes voice toggle button
   - Voice button conditionally rendered based on `voiceEnabled`
   - Text-only mode indicator shown when voice is disabled

## Usage

### Enabling/Disabling Voice
1. Open the Greene Guide chatbot
2. Click the speaker icon (🔊) in the header to toggle voice on/off
3. The button icon will change to reflect the current state

### Text-Only Mode
- User can still type messages normally
- Click Send button or press Enter to submit messages
- Bot responses appear as text only
- User can re-enable voice anytime by clicking the speaker icon

### Voice Mode
- Speak button (🎤) is available for voice input
- All bot responses are automatically spoken
- Users can continue typing while in voice mode

## Browser Support
- Voice toggle works on all modern browsers
- Voice features require browser Speech Recognition API support
- Text-only mode works on all browsers (no APIs required)

## Technical Details

### State Variables
```typescript
const voiceEnabled = ref(true) // Track voice enabled/disabled state
```

### Conditional Rendering
- Voice button: `v-if="voiceEnabled"`
- Text mode indicator: `v-else`

### Voice Control
- When disabled: `speakMessage()` is skipped in `sendMessage()`
- Speech synthesis is cancelled when toggling voice off
- Voice recognition is stopped if active when toggling

## Testing Checklist
✅ Voice button visible in header
✅ Toggle switches between voice enabled/disabled
✅ Icon changes appropriately
✅ Text-only mode message displays when voice disabled
✅ Voice button hidden when voice disabled
✅ Bot speaks responses when voice enabled
✅ Bot only texts when voice disabled
✅ Text input works in both modes
✅ Ongoing speech cancels when toggling
✅ Dark mode styling works for toggle button

## Future Enhancements
- Persist voice preference to localStorage (remembers user choice)
- Add keyboard shortcut to toggle voice (e.g., Cmd+Shift+V)
- Sound indicator when switching modes
- Analytics: Track how many users prefer text vs voice mode
